﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


namespace DemoRecorder
{
    public partial class DemoRecorder : Form
    {
        public DemoRecorder()
        {
            InitializeComponent();

            Init();

            m_videoDeviceList = av.MediaRecorder.GetCameraDeviceList();
            m_audioDeviceList = av.MediaRecorder.GetSoundDeviceList();

            InitControl();
        }

        private void InitControl()
        {
            comboBoxChannels.Items.Add("1");
            comboBoxChannels.Items.Add("2");
            comboBoxChannels.SelectedIndex = 1;

            comboBoxSampleRate.Items.Add("44100");
            comboBoxSampleRate.Items.Add("16000");
            comboBoxSampleRate.Items.Add("8000");
            comboBoxSampleRate.SelectedIndex = 0;

			comboBoxResolution.Items.Add("720*576");
            comboBoxResolution.Items.Add("640*480");
			comboBoxResolution.Items.Add("352*288");
            comboBoxResolution.Items.Add("320*240");
            comboBoxResolution.SelectedIndex = 1;

			comboBoxFrameRate.Items.Add(30);
            comboBoxFrameRate.Items.Add(25);
			comboBoxFrameRate.Items.Add(20);
			comboBoxFrameRate.Items.Add(15);
            comboBoxFrameRate.Items.Add(10);
            comboBoxFrameRate.SelectedIndex = 0;

            foreach (av.DeviceInfo dev in m_videoDeviceList)
            {
                comboBoxCamera.Items.Add(dev.name);
            }
            if (m_videoDeviceList.Length > 0)
            {
                comboBoxCamera.SelectedIndex = 0;
            }

            foreach (av.DeviceInfo dev in m_audioDeviceList)
            {
                comboBoxSound.Items.Add(dev.name);
            }
            if (m_audioDeviceList.Length > 0)
            {
                comboBoxSound.SelectedIndex = 0;
            }

            textBoxRecord.Text = "demo.mp4";
            textBoxMediaName.Text = "demo";
        }

        private void Init()
        {
            av.MediaRecorder.Init();
            System.Console.WriteLine(av.MediaRecorder.GetVersion());

            av.MediaRecorder.StartMediaServer(av.MediaRecorder.RTSP_PORT);
        }

        private void Uninit()
        {
            CloseRecorder();

            av.MediaRecorder.StopMediaServer();
            av.MediaRecorder.Quit();

            System.Console.WriteLine("quit");
        }

        private void CloseRecorder()
        {
            if (m_recorder != null)
            {
                m_recorder.Close();
                m_recorder = null;
            }
        }

        private av.DeviceInfo[] m_videoDeviceList;
        private av.DeviceInfo[] m_audioDeviceList;
        private av.MediaRecorder m_recorder;


        private void buttonStart_Click(object sender, EventArgs e)
        {
            CloseRecorder();

            int camera = getCamera();
            int sound = getSound();
            m_recorder = av.MediaRecorder.Open(camera, sound);
            if (m_recorder == null)
            {
                MessageBox.Show("创建录像机失败");
                return;
            }
            else
            {
                Size resolution = getResolution();
                m_recorder.SetResolution(resolution.Width, resolution.Height);
                int fps = getFrameRate();
                m_recorder.SetFrameRate(fps);

                int channels = getChannels();
                int sampleRate = getSampleRate();
                m_recorder.SetAudioProfile(channels, sampleRate, 16);

                m_recorder.SetOutputFile(textBoxRecord.Text);
                m_recorder.StartPublish(textBoxMediaName.Text);
                m_recorder.Start();

                onStartRecord();
            }
        }

        private void buttonStop_Click(object sender, EventArgs e)
        {
            CloseRecorder();
            onStopRecord();
        }

        private void DemoRecorder_FormClosed(object sender, FormClosedEventArgs e)
        {
            Uninit();
        }

        private void onStartRecord()
        {
            this.Text = "recording ...";
        }

        private void onStopRecord()
        {
            this.Text = "DemoRecorder";
        }

        private int getCamera()
        {
            return comboBoxCamera.SelectedIndex;
        }

        private int getSound()
        {
            return comboBoxSound.SelectedIndex;
        }

        private Size getResolution()
        {
            string[] strs = comboBoxResolution.Text.Split('*');
            int width = Int32.Parse(strs[0]);
            int height = Int32.Parse(strs[1]);
            return new Size(width, height);
        }

        private int getChannels()
        {
            return Int32.Parse(comboBoxChannels.Text);
        }

        private int getSampleRate()
        {
            return Int32.Parse(comboBoxSampleRate.Text);
        }

        private int getFrameRate()
        {
            return Int32.Parse(comboBoxFrameRate.Text);
        }

    }
}
