/*    file: Main.cpp
 *    desc:
 * 
 * created: 2016-01-13
 *  author: chuanjiang.zh@qq.com
 * company: 
 */

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <string>

#include "LibMediaRecorder.h"
#include "TStringUtil.h"


class MRContext
{
public:
    MRContext()
    {
        MR_Init();
    }

    ~MRContext()
    {
        MR_Quit();
    }

};

void enumDevice()
{
    MRDeviceInfo devInfos[MR_MAX_DEVICE];
    memset(devInfos, 0, sizeof(devInfos));
    int count = MR_MAX_DEVICE;
    int rc = MR_GetCameraDeviceList(devInfos, &count);
    for (int i = 0; i < count; ++ i)
    {
        std::cout << devInfos[i].name << std::endl;
    }

    std::cout << "----------\n";

    memset(devInfos, 0, sizeof(devInfos));
    count = MR_MAX_DEVICE;
    rc = MR_GetSoundDeviceList(devInfos, &count);
    for (int i = 0; i < count; ++ i)
    {
        std::cout << devInfos[i].name << std::endl;
    }


}

void enumEncoder()
{
    MREncoderInfo encoders[MR_MAX_ENCODER];
    memset(encoders, 0, sizeof(encoders));
    int count = MR_MAX_ENCODER;
    int rc = MR_GetVideoEncoderList(encoders, &count);
    for (int i = 0; i < count; ++ i)
    {
        std::cout << encoders[i].name << std::endl;
    }

    std::cout << "----------\n";
    memset(encoders, 0, sizeof(encoders));
    count = MR_MAX_ENCODER;
    rc = MR_GetSoundEncoderList(encoders, &count);
    for (int i = 0; i < count; ++ i)
    {
        std::cout << encoders[i].name << std::endl;
    }
    
}

int main(int argc, char** argv)
{
    MRContext context;

    std::cout << MR_GetVersion() << std::endl;

    enumDevice();
    enumEncoder();
    
    MR_StartMediaServer(MR_RTSP_PORT);

    //
    MR_HANDLE handle = MR_OpenRecorder(0, 0);
    if (handle == NULL)
    {
        std::cout << "open recorder failed.\n";
        return -1;
    }

    int width = 0;
    int height = 0;
    int fps = 0;
    MR_GetResolution(handle, &width, &height);
    MR_GetFrameRate(handle, &fps);
    std::cout << width << "*" << height << ":" << fps << std::endl;

    MR_SetResolution(handle, 352, 288);
    //MR_SetVideoBitrate(handle, 1024 * 128);

    MR_SetAudioProfile(handle, 1, 16000, 16);

    int channels = 0;
    int samplerate = 0;
    int sampleBits = 0;
    MR_GetAudioProfile(handle, &channels, &samplerate, &sampleBits);
    std::cout << channels << "*" << samplerate << ":" << sampleBits << std::endl;

    std::string filename = "demo.mp4";
    MR_SetOutputFile(handle, filename.c_str());

    MR_Start(handle);

    MR_StartPublish(handle, "demo");

    while(true)
    {
        std::cout << ">>";
        std::string line;
        std::getline(std::cin, line);
        if (std::cin.good())
        {
            if ((line == "q") || (line == "quit"))
            {
                break;
            }
            else if (line == "pause")
            {
                MR_Pause(handle);
            }
            else if (line == "play")
            {
                MR_Start(handle);
            }
            else if (line == "rec")
            {
                static int s_count = 0;
                s_count ++;
                std::string name = comn::StringUtil::format("demo-%d.mp4", s_count);
                MR_SetOutputFile(handle, name.c_str());
            }
        }
        else 
        {
            std::cin.clear();
        }
    }

    //MR_StopPublish(handle);

    MR_CloseRecorder(handle);


    MR_StopMediaServer();

    return 0;
}





